import os
import tkinter as tk
from tkinter import messagebox
import PIL
from PIL import Image, ImageTk
  # Ajouté pour l'image
import shutil
import os
import shutil
import ctypes
import os
import ctypes
import pymupdf
#import pywin32
from win32com.client import Dispatch


BASE_DIR = os.path.dirname(os.path.abspath(__file__))


def get_desktop():
    # Récupère le chemin réel du bureau (fonctionne sur toutes les versions Windows) : le chemin de l'icône sur le bureau sera ainsi automatiquement détecté)
    CSIDL_DESKTOP = 0
    SHGFP_TYPE_CURRENT = 0
    buf = ctypes.create_unicode_buffer(260)
    ctypes.windll.shell32.SHGetFolderPathW(None, CSIDL_DESKTOP, None, SHGFP_TYPE_CURRENT, buf)
    return buf.value

def placer_raccourci_sur_bureau(
    nom_icone="Icône menu.ico",
    script="Cycle frigorifique.bat",
    nom_raccourci="Cycle frigorifique.lnk"):


    BASE_DIR = os.path.dirname(os.path.abspath(__file__))
    bureau = get_desktop()
    chemin_icone = os.path.join(BASE_DIR, nom_icone)
    chemin_script = os.path.join(BASE_DIR, script)
    chemin_raccourci = os.path.join(bureau, nom_raccourci)

    print("Chemin icône script :", chemin_icone)
    print("Chemin script :", chemin_script)
    print("Chemin raccourci :", chemin_raccourci)

    # Créer le raccourci si absent
    if not os.path.exists(chemin_raccourci):
        shell = Dispatch('WScript.Shell')
        shortcut = shell.CreateShortCut(chemin_raccourci)
        shortcut.Targetpath = chemin_script
        shortcut.WorkingDirectory = BASE_DIR
        shortcut.IconLocation = chemin_icone  # Utilise l'icône du dossier du script
        shortcut.save()
        print(f"Raccourci créé sur le bureau : {chemin_raccourci}")
    else:
        print("Le raccourci est déjà présent sur le bureau.")



def lancer_programme_principal():
    try:
        root.destroy()
        os.system(f'py "{os.path.join(BASE_DIR, "main_prog.py")}"')
    except Exception as e:
        messagebox.showerror("Erreur", f"Impossible de lancer le programme principal : {str(e)}")

def lancer_programme_9():
    try:
        root.destroy()
        os.system(f'python "{os.path.join(BASE_DIR, "main_prog.py")}"')
    except Exception as e:
        messagebox.showerror("Erreur", f"Impossible de lancer le programme 9 : {str(e)}")




import os
import sys
import subprocess

def ouvrir_tutoriel():
    # Récupère le chemin absolu du dossier où se trouve le script
    base_dir = os.path.dirname(os.path.abspath(__file__))
    fichier_pdf = "Notice dutilisation du programme Cycle frigorifique à destination des utilisateurs.pdf"
    chemin_pdf = os.path.join(base_dir, fichier_pdf)

    # Vérifier si le fichier existe dans le répertoire de travail
    if not os.path.exists(chemin_pdf):
        messagebox.showerror("Erreur", f"Le fichier {fichier_pdf} n'existe pas dans le dossier :\n{base_dir}")
        return

    # Ouvre le PDF avec le lecteur par défaut selon le système
    try:
        if sys.platform.startswith('darwin'):  # macOS
            subprocess.call(('open', chemin_pdf))
        elif os.name == 'nt':  # Windows
            os.startfile(chemin_pdf)
        elif os.name == 'posix':  # Linux
            subprocess.call(('xdg-open', chemin_pdf))
        else:
            messagebox.showerror("Erreur", "Système d'exploitation non supporté.")
    except Exception as e:
        messagebox.showerror("Erreur", f"Erreur lors de l'ouverture du PDF :\n{e}")






placer_raccourci_sur_bureau()
root = tk.Tk()
root.title("Lanceur de programmes")
root.geometry("600x640")
root.configure(bg="#add8e6")

# Affichage de l'image (icône)
try:
    image_path = os.path.join(BASE_DIR, "images", "Icône menu.png")
    img = Image.open(image_path)
    img = img.resize((300, 300))
    photo = ImageTk.PhotoImage(img)
    img_label = tk.Label(root, image=photo, bg="#4682B4")
    img_label.image = photo  # <-- Garde la référence ici !
    img_label.pack(pady=(20, 10))
except Exception as e:
    img_label = tk.Label(root, text="[Image manquante]", font=("Arial", 12), bg="#add8e6", fg="red")
    img_label.pack(pady=(20, 10))

# Titre
titre = tk.Label(root, text="Le cycle frigorifique ",
                font=("Arial", 22, "bold"), bg="#add8e6", pady=20)
titre.pack()

# Boutons
frame_boutons = tk.Frame(root, bg="#add8e6")
frame_boutons.pack(expand=True)

btn_principal = tk.Button(frame_boutons, text="Programme Principal",
                         font=("Arial", 12), width=25, height=2,
                         command=lancer_programme_principal)
btn_principal.pack(pady=10)

btn_tutoriel = tk.Button(frame_boutons, text="Tutoriel",
                        font=("Arial", 12), width=25, height=2,
                        command=ouvrir_tutoriel)
btn_tutoriel.pack(pady=10)

btn_quitter = tk.Button(frame_boutons, text="Quitter",
                       font=("Arial", 12), width=15,
                       command=root.destroy)
btn_quitter.pack(pady=20)

# Pied de page
footer = tk.Label(root, text="© 2025 - Tous droits réservés",
                 font=("Arial", 8), bg="#add8e6")
footer.pack(side=tk.BOTTOM, pady=10)

root.mainloop()

