import rclpy
from ackermann_msgs.msg import AckermannDrive
from sensor_msgs.msg import LaserScan
from rclpy.node import Node


class Noeudconduite(Node):
    def __init__(self):
        super().__init__('CoVAPSy_conduiteR')

        # ROS interface
        self.__ackermann_publisher = self.create_publisher(AckermannDrive, 'cmd_ackermann', 1)
        self.create_subscription(LaserScan, 'scan', self.__on_lidar_acquisition, 1)
        self.get_logger().info('noeud cree')

    def __on_lidar_acquisition(self, message):
        tableauLidar = list(message.ranges)
        self.get_logger().info(f'60 {tableauLidar[533]:.2f} et -60 {tableauLidar[2666]:.2f}')
        command_message = AckermannDrive()
        command_message.speed = 1.0
        try:
            command_message.steering_angle = 100 * (tableauLidar[533] - tableauLidar[2666])
        except IndexError:
            command_message.steering_angle = 0.0
        if command_message.steering_angle > 18.0:
            command_message.steering_angle = 18.0
        if command_message.steering_angle < -18.0:
            command_message.steering_angle = -18.0
        self.__ackermann_publisher.publish(command_message)
        self.get_logger().info(f'v = {command_message.speed:.2f} m/s, dir = {command_message.steering_angle:.2f} rad')


def main(args=None):
    rclpy.init(args=args)
    noeud = Noeudconduite()
    rclpy.spin(noeud)
    rclpy.shutdown()


if __name__ == '__main__':
    main()
