from setuptools import find_packages, setup

package_name = 'monPaquetCoVAPSy'

data_files = []
data_files.append(('share/ament_index/resource_index/packages', ['resource/' + package_name]))
data_files.append(('share/' + package_name + '/launch', ['launch/monPaquetCoVAPSy_launch.py']))
data_files.append(('share/' + package_name + '/worlds', ['worlds/Piste_CoVAPSy_2025a.wbt']))
data_files.append(('share/' + package_name + '/worlds', ['worlds/ImageToStl_virage.obj']))
data_files.append(('share/' + package_name + '/resource', ['resource/TT02_jaune_python.urdf']))
data_files.append(('share/' + package_name + '/protos', ['protos/TT02_2025a.proto']))
data_files.append(('share/' + package_name + '/protos', ['protos/TT02Wheel.proto']))
data_files.append(('share/' + package_name + '/protos', ['protos/ChevroletCamaroLight.stl']))
data_files.append(('share/' + package_name + '/controllers/controller_violet',
    ['controllers/controller_violet/controller_violet.py']))
data_files.append(('share/' + package_name, ['package.xml']))


setup(
    name=package_name,
    version='0.0.0',
    packages=find_packages(exclude=['test']),
    data_files=data_files,
    install_requires=['setuptools'],
    zip_safe=True,
    maintainer='webotsros2',
    maintainer_email='webotsros2@toto.fr',
    description='paquet de commande de la voiture CoVAPSy simulee',
    license='Apache-2.0',
    tests_require=['pytest'],
    entry_points={
        'console_scripts': [
            'CoVAPSy_cmd = monPaquetCoVAPSy.CoVAPSy_cmd:main',
            'CoVAPSy_conduite = monPaquetCoVAPSy.CoVAPSy_conduite:main'
        ],
    },
)
