import os
import launch
from launch_ros.actions import Node
from launch import LaunchDescription
from ament_index_python.packages import get_package_share_directory
from webots_ros2_driver.webots_launcher import WebotsLauncher
from webots_ros2_driver.webots_controller import WebotsController

def generate_launch_description():
    package_dir = get_package_share_directory('monPaquetCoVAPSy')
    robot_description_path = os.path.join(package_dir, 'resource', 'TT02_jaune_python.urdf')
    
    webots = WebotsLauncher(world=os.path.join(package_dir, 'worlds', 'Piste_CoVAPSy_2025a.wbt'))

    CoVAPSy_cmd = WebotsController(
        robot_name='TT02_jaune_python', parameters=[{'robot_description': robot_description_path},]
        )

    CoVAPSy_conduite = Node(
        package='monPaquetCoVAPSy',
        executable='CoVAPSy_conduite',
    )

    return LaunchDescription([
        webots,
        CoVAPSy_cmd,
        CoVAPSy_conduite,
        launch.actions.RegisterEventHandler(
            event_handler=launch.event_handlers.OnProcessExit(
                target_action=webots,
                on_exit=[launch.actions.EmitEvent(event=launch.events.Shutdown())],
            )
        )
    ])
