import rclpy
from sensor_msgs.msg import LaserScan
from ackermann_msgs.msg import AckermannDrive
from rclpy.node import Node

class CoVAPSy_conduite(Node):
    def __init__(self):
        super().__init__('CoVAPSy_conduite')

        # ROS interface
        self.__ackermann_publisher = self.create_publisher(AckermannDrive, 'cmd_ackermann',1)
        self.create_subscription(LaserScan, 'TT02_jaune_python/RpLidarA2', self.__on_lidar_acquisition,1)
        self.get_logger().info(f"[CoVAPSy_conduite] noeud cree")


    def __on_lidar_acquisition(self, message):
        tableauLidar = list(message.ranges)
        self.get_logger().info(f'60 {tableauLidar[120]:.2f} et -60 {tableauLidar[240]:.2f}')
        command_message = AckermannDrive()
        command_message.speed = 1.0
        try:
            command_message.steering_angle = 100 * (tableauLidar[120] - tableauLidar[240])
        except IndexError:
            command_message.steering_angle = 0.0
        if command_message.steering_angle > 18.0:
            command_message.steering_angle = 18.0
        if command_message.steering_angle < -18.0:
            command_message.steering_angle = -18.0
        self.__ackermann_publisher.publish(command_message)
        self.get_logger().info(f"v = {command_message.speed:.2f} m/s, dir = {command_message.steering_angle:.2f} rad")

def main(args=None):
    rclpy.init(args=args)
    controller = CoVAPSy_conduite()
    rclpy.spin(controller)
    rclpy.shutdown()


if __name__ == '__main__':
    main()
