import rclpy
from ackermann_msgs.msg import AckermannDrive


class CoVAPSy_cmd:
    def init(self, webots_node, properties):
        self.__robot = webots_node.robot
        self.__vitesse_m_s = 0.0
        self.__direction_degre = 0
        # ROS interface
        rclpy.init(args=None)
        self.__node = rclpy.create_node('CoVAPSy_cmd')
        self.__node.create_subscription(AckermannDrive, 'cmd_ackermann', self.__cmd_ackermann_callback, 1)
        self.__node.get_logger().info("noeud cree")
        self.__robot.setCruisingSpeed(self.__vitesse_m_s*3.6)
        self.__robot.setSteeringAngle(-self.__direction_degre*3.14/180)

    def __cmd_ackermann_callback(self, message):
        self.__vitesse_m_s = message.speed
        self.__direction_degre = message.steering_angle
        # self.__node.get_logger().info(
        #     f"[CoVAPSy_cmd] Reçu : vitesse = {self.__vitesse_m_s} m/s, direction = {self.__direction_degre}°")
    
    def step(self):
        rclpy.spin_once(self.__node, timeout_sec=0)
        self.__robot.setCruisingSpeed(self.__vitesse_m_s*3.6)
        self.__robot.setSteeringAngle(-self.__direction_degre*3.14/180)
