scServices.evalScore = {
	fEvals : {},
	fNumEvals : null,
	fScore : null,
	fSuccessStatus : null,
	getScore : function () {
		return this.fScore;
	},
	getSuccessStatus : function () {
		return this.fSuccessStatus;
	},
	setEvalNumber : function (pNum) {
		this.fNumEvals = pNum;
	},
	setEvalScore : function(pId, pMinPts, pSorePts, pMaxPts){
		try {
			if (!this.fNumEvals || this.fNumEvals < 1) throw "Cannot set global evaluation score : unknown number of evaluations";
			let vApi, vTotalScore = 0;
			this.fEvals[pId] = {minPts:pMinPts, scorePts:pSorePts, maxPts:pMaxPts, score:Math.round( (pSorePts - pMinPts) / (pMaxPts - pMinPts) * 100)};
			for (let vId in this.fEvals){
				const vEval = this.fEvals[vId];
				vTotalScore += vEval.score;
			}
			this.fScore = vTotalScore / this.fNumEvals;
			if(scServices.scorm2k4 && scServices.scorm2k4.isScorm2k4Active()) {
				vApi = scServices.scorm2k4.getScorm2k4API();
				vApi.SetValue("cmi.score.scaled", this.fScore/100 );
				vApi.SetValue("cmi.score.raw", this.fScore );
				vApi.SetValue("cmi.score.min", 0 );
				vApi.SetValue("cmi.score.max", 100 );
				const vPassingScore = vApi.GetValue("cmi.scaled_passing_score") || 1;
				this.fSuccessStatus = this.fScore/100>=vPassingScore ? "passed" : "failed";
				vApi.SetValue("cmi.success_status", this.fSuccessStatus);
				if(scServices.completionStorage) scServices.completionStorage.commit(false);
				scServices.assmntMgr.commit(false);
				vApi.Commit("");
			} else if(scServices.scorm12 && scServices.scorm12.isScorm12Active()) {
				vApi = scServices.scorm12.getScorm12API();
				vApi.LMSSetValue("cmi.core.score.raw", this.fScore);
				vApi.LMSSetValue("cmi.core.score.min", "0" );
				vApi.LMSSetValue("cmi.core.score.max", "100" );
				const vLaunchData = vApi.LMSGetValue("cmi.launch_data");
				const vLaunchDataObj = scServices.dataUtil.deserialiseObjJs(vLaunchData);
				const vPassingScore = vLaunchDataObj["passingScore"] || 1;
				this.fSuccessStatus = this.fScore/100>=vPassingScore ? "passed" : "failed";
				if(scServices.completionStorage) scServices.completionStorage.commit(false)
				scServices.assmntMgr.commit(false);
				vApi.LMSCommit("");
			} else if(scServices.distribRecords && scServices.distribRecords.isDistribRecordsActive()){
				scServices.distribRecords.setMainScore(this.fScore, 0, 100, true);
			}
		} catch (e){
			console.error(`scServices.evalScore.setEvalScore() - ERROR : ${e}`);
		}
	}
}
