/** Gère le statut des pages vues */
scServices.markedPages = scOnLoads[scOnLoads.length] = {
	/**
	 * Retourne true si la page est marquée
	 */
	isPageMarked: function(pUrl){
		const vKey = this.getIdFromUrl(pUrl);
		return !!this.fPagesSeen[vKey];
	},
	isPageMarkedId: function(pId){
		return !!this.fPagesSeen[pId];
	},
	/**
	 * Retourne un objet contenant la liste des pages marquées
	 * {id1, id2, ...}
	 */
	getPagesMarked : function(){
		return this.fPagesSeen;
	},
	/**
	 * Retourne une string listant les pages marquées
	 * {id1, id2, ...}
	 */
	getPagesMarkedStr : function(){
		let vResult = "";
		for(let vNode in scServices.markedPages.getPagesMarked()){
			vResult += vNode + ',';
		}
		return vResult;
	},
	/**
	 * Ajoute une page marquée
	 */
	addPageMarked : function(pUrl) {
		const vKey = this.getIdFromUrl(pUrl);
		return this.addPageMarkedId(vKey);
	},
	addPageMarkedId : function(pId) {
		if(! this.fPagesSeen[pId]) {
			this.fPagesSeen[pId] = true;
			this.fCountSeen++;
			if(scServices.suspendDataStorage){
				scServices.suspendDataStorage.setVal(this.fSuspendDataKey, this.getPagesMarkedStr());
				scServices.suspendDataStorage.commit();
			}
		}
	},
	/**
	 * Supprime une page marquée
	 */
	removePageMarked : function(pUrl) {
		const vKey = this.getIdFromUrl(pUrl);
		return this.removePageMarkedId(vKey);
	},
	removePageMarkedId : function(pId) {
		if(this.fPagesSeen[pId]) {
			delete this.fPagesSeen[pId];
			this.fCountSeen--;
			if(scServices.suspendDataStorage){
				scServices.suspendDataStorage.setVal(this.fSuspendDataKey, this.getPagesMarkedStr());
				scServices.suspendDataStorage.commit();
			}
		}
	},
	/**
	 * Inverse l'état d'une page marquée
	 * @return : true si le nouvel état est marqué; false sinon
	 */
	togglePageMarkedId: function(pId) {
		this.fPagesSeen[pId] ? this.removePageMarkedId(pId) : this.addPageMarkedId(pId);
		return !!this.fPagesSeen[pId];
	},
	/**
	 * Retourne un id de page à partir de son url
	 */
	getIdFromUrl : function(pUrl){
		return pUrl.substring(pUrl.lastIndexOf("/")+1, pUrl.length-5);
	},
	/**
	 * Retourne un indicateur de progression des pages marquées
	 * @return [0,1]
	 */
	getProgression: function(){
		if(scServices.totalPages){
			return this.fCountSeen/scServices.totalPages;
		}
		return undefined;
	},

	hasLastLocation: function(){
		return !!this.fLastLocation;
	},

	isLastLocation: function(pLocation){
		return pLocation === this.fLastLocation;
	},

	getLastLocation: function(){
		if(this.fLastLocation) {
			let vLastLoc = this.fLastLocation;
			this.fLastLocation = null;
			return vLastLoc;
		}
	},

	/**
	 * Retourne un indicateur de completion des pages marquées
	 * @return [completed,incomplete]
	 */
	getCompletionStatus : function(){
		let vCompletedThreshold = 1;
		if(scServices.scorm2k4 && scServices.scorm2k4.isScorm2k4Active()) {
			const vApi = scServices.scorm2k4.getScorm2k4API();
			const vScormCompletedThreshold = vApi.GetValue("cmi.completion_threshold");
			if(vScormCompletedThreshold!=null && vScormCompletedThreshold!=="") vCompletedThreshold = vScormCompletedThreshold;
		}
		if(typeof this.getProgression() ===  undefined) return undefined;
		if(this.getProgression() === vCompletedThreshold){
			return "completed"
		}else{
			return "incomplete";
		}
	},
	fCountSeen : 0,
	fPagesSeen :{},
	fSuspendDataKey : null,
	onLoad : function() {
		try{
			// Initialisation du gestionnaire de pages vues
			if (scServices.suspendDataStorage) {
				this.fSuspendDataKey = ["pg"];
				const vSuspendDataVal = scServices.suspendDataStorage.getVal(this.fSuspendDataKey) || "";
				if(vSuspendDataVal) {
					const vArr = vSuspendDataVal.split(",");
					let i = 0;
					const l = vArr.length;
					for(; i<l; i++){
						if(vArr[i]){
							this.fPagesSeen[vArr[i]] = true;
							this.fCountSeen++;
						}
					}
				}
			}

			// Mémorisation de lastLocation
			if(scServices.locationStorage) {
				this.fLastLocation = scServices.locationStorage.getLocation();
			}
		} catch(e){console.log("ERROR scServices.markedPages.onLoad: "+e);}
	},
	loadSortKey : "5markedPage"
}
