﻿scServices.currentPage = scOnLoads[scOnLoads.length] = {
	fActive : true,
	fCurrentHash : "",
	fBaseUrl : (scUrlToLoad ? scUrlToLoad : scServices.scLoad.getUrlFromRoot(scCoLib.hrefBase())),

	set : function(pUrl) {
		const vPge = pUrl.substring(pUrl.lastIndexOf("/") + 1);
		const vNewHash = vPge.substring(0, vPge.lastIndexOf("."));
		if (this.fActive){
			this.fCurrentHash = vNewHash;
			history.replaceState(null, null, scCoLib.hrefBase() + "#" + vNewHash);
		} else if(window.location.hash.length > 0){
			const vHash = decodeURIComponent(window.location.hash).substring(1);
			if (vHash!==vNewHash) history.replaceState(null, null, ' ');
		}
	},
	enable : function() {
		this.fActive = true;
	},
	disable : function() {
		this.fActive = false;
	},
	hashChange : async function() {
		if(window.location.hash.length > 0){
			const vHash = decodeURIComponent(window.location.hash).substring(1);
			if (vHash === this.fCurrentHash) return;
			const vPageUrl = this.fBaseUrl.substring(0, this.fBaseUrl.lastIndexOf("/") + 1) + vHash + this.fBaseUrl.substring(this.fBaseUrl.lastIndexOf("."));
			try{
				const vReq = await fetch(vPageUrl);
				if (!vReq.ok) throw new Error(`Status: ${vReq.status}`);
				sc$("mainFrame").src = vPageUrl;
			} catch (e) {
				console.error(`ERROR - scServices.currentPage.hashChange : ${e}`);
				return null;
			}
	}
	},
	onLoad : function() {
		try {
			if(window.location.hash.length > 0){
				const vHash = decodeURIComponent(window.location.hash).substring(1);
				const vPageUrl = this.fBaseUrl.substring(0, this.fBaseUrl.lastIndexOf("/") + 1) + vHash + this.fBaseUrl.substring(this.fBaseUrl.lastIndexOf("."));
				try {
					fetch(scServices.scLoad.resolveDestUri("/" + vPageUrl)).then(function (pResponse){
						if (!pResponse.ok) throw new Error(`Status: ${pResponse.status}`);
						scUrlToLoad = vPageUrl;
					})
				} catch(e){}
			}
		} catch (e) {
			console.log("scServices.currentPage.onLoad : " + e);
		}
	},
	loadSortKey : "1currentPage"
}
window.addEventListener("hashchange", function() {
	scServices.currentPage.hashChange();
});